#ifndef USER_API_H
#define USER_API_H

#include "NN_data.h"
#include "App1_variable.h"
#include <Python.h>
#include <iostream>
#include <stdarg.h>
#include "vector"
using namespace std;

void init_python_config();

class User_api {
	private:
		NN_data* nn_data;
		User_parameter* user_parameter;
		NN_parameter* nn_parameter;
		const app1_gradient* gradient;
		PyObject* nn_module = NULL;
		PyObject* func_load_dataset = NULL;
		PyObject* func_set_nnparameters = NULL;
		PyObject* func_update_nndata = NULL;
		PyObject* func_backpropagation = NULL;
		template <typename T> PyObject* call_func(string, int, PyObject*, ...);
		template <typename T> PyObject* call_func(string func_name, PyObject* obj, PyObject* objtwo, int mode);
	public:
		User_api(const char*, NN_data*, User_parameter*, NN_parameter*, app1_gradient*);
		void clear(void);
		void set_userparameters(int n_internal_test_case, int n_rank, double th,  double beta, double lambda, double xi);
		void set_userparameter(string, int);
		void set_userparameter(string, double, ...);
		int get_userparameter_int(string);
		double get_userparameter_double(string);
		void set_nnparameters(double dropout = 0.38, double alpha = 0.2, double lr = 0.001, double weight_decay = 0.);
		void set_nnparameter(string, double);
		template <typename T> T get_nnparameter(string);
		int get_nndata(string);
		double get_nndata(string,int, int);
		void load_dataset(int*);
		void update_nndata_batch(int, vector<int>, vector<int>);
};

#endif